<?php
/*
=====================================================
 DleMovie (Module for CMS DataLife Engine)
-----------------------------------------------------
 Copyright (c) 2011, 2012 Alexander Ahminenko
=====================================================
     
-----------------------------------------------------
 E-Mail, ICQ: a.ahminenko@gmail.com, 681216
=====================================================
*/
@session_start( );
@error_reporting( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set( 'display_errors', true );
@ini_set( 'html_errors', false );
@ini_set( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

define( 'DATALIFEENGINE', true );
define( 'ROOT_DIR', '../../../..' );
define( 'ENGINE_DIR', ROOT_DIR . '/engine' );
define( 'DLEMOVIE_DIR', ROOT_DIR . '/engine/modules/dlemovie' );

include_once ENGINE_DIR . '/data/config.php';
include_once ENGINE_DIR . '/classes/mysql.php';
include_once ENGINE_DIR . '/data/dbconfig.php';
include_once ENGINE_DIR . '/modules/functions.php';
include_once ENGINE_DIR . '/modules/sitelogin.php';
include_once ENGINE_DIR . '/classes/parse.class.php';

if ( $config['http_home_url'] == "" ) {
	$config['http_home_url'] = explode( "engine/modules/dlemovie/ajax/favorite.php", $_SERVER['PHP_SELF'] );
	$config['http_home_url'] = reset( $config['http_home_url'] );
	$config['http_home_url'] = "http://" . $_SERVER['HTTP_HOST'] . $config['http_home_url'];
}

include_once ENGINE_DIR . '/data/dlemovie.php';
include_once DLEMOVIE_DIR . '/classes/dlemovie.class.php';
$dlemovie = new DleMovie( $db, $dlemovie_config, $config );
$parse = new ParseFilter( );

$user_group = get_vars( "usergroup" );
if( ! $user_group ) {
    $user_group = array( );
    $db->query( "SELECT * FROM " . USERPREFIX . "_usergroups ORDER BY id ASC" );
    while ( $row = $db->get_row( ) ) {
        $user_group[$row['id']] = array( );
        foreach ( $row as $key => $value ) {
            $user_group[$row['id']][$key] = stripslashes( $value );
        }
    }
    set_vars( "usergroup", $user_group );
    $db->free( );
}
$dlemovie->category = get_vars( 'dlemovie-category' );
if ( ! is_array( $dlemovie->category ) ) {
	$dlemovie->category = array( );
	$db->query( "SELECT * FROM " . PREFIX . "_dm_category ORDER BY posi ASC" );
	while ( $row = $db->get_row( ) ) {
		$dlemovie->category[$row['id']] = array( );
		foreach ( $row as $key => $value ) $dlemovie->category[$row['id']][$key] = stripslashes( $value );
	}
	set_vars( 'dlemovie-category', $dlemovie->category );
	$db->free( );
}

$url = trim( $_POST['url'] );
$category = intval( $_POST['category'] );
$datetime = time( );

if ( ! $is_logged ) $member_id['user_group'] = 5;
if ( $user_group[$member_id['user_group']] < 2 ) die( 'NotAllowed' );
if ( $category <= 0 and $dlemovie->config['categories'] != 'yes' ) die( 'NotCategory' );
if ( $dlemovie->config['categories'] != 'yes' ) $category = 0;
if ( empty( $url ) ) die( 'EmptyUrl' );

$clip = array( );
if ( $dlemovie->isVideoUrl( $url, $clip ) ) {
	$provider = $clip['provider'];
	$video = $dlemovie->videoImport( $clip['videoid'], $clip['provider'] );
	if ( $video !== false ) {
		if ( ! empty( $video['extra-provider'] ) ) {
			$provider = $clip['provider'] = $video['extra-provider'];
			$clip['videoid'] = $video['extra-id'];
		}
		$title = $db->safesql( $parse->process( $video['title'] ) );
		$descr = $db->safesql( $parse->process( $video['descr'] ) );
		if ( ! empty( $video['screen-hq']['url'] ) ) $screen = $dlemovie->screenSave( $video['screen-hq']['url'], $video['screen-hq']['width'] );
		elseif ( ! empty( $video['screen']['url'] ) ) $screen = $dlemovie->screenSave( $video['screen']['url'], $video['screen']['width'] );
		else $screen = '';
		$videoid = ( ! empty( $clip['specid'] ) ) ? $clip['specid'] : $clip['videoid'];
		if ( ! empty( $video['videoid'] ) ) $videoid = $video['videoid'];
		$db->query( "INSERT INTO " . PREFIX . "_dm_videos ( title, descr, video, provider, screen, playtime, category, member, date, allowcomm, approved ) VALUES ( '$title', '$descr', '$videoid', '$provider', '$screen', '$video[duration]', '$category', '$member_id[name]', '$datetime', '1', '1' )" );
		$unicalid = $db->insert_id( );
		if ( $dlemovie->config['categories'] == 'yes' ) {
			if ( $dlemovie->category[$category]['previewup'] == 1 ) $db->query( "UPDATE " . PREFIX . "_dm_category SET videos = videos + 1, preview = '../$screen' WHERE id = '$category'" );
			else $db->query( "UPDATE " . PREFIX . "_dm_category SET videos = videos + 1 WHERE id = '$category'" );
			$dlemovie->cacheClear( 'category' );
		}
		die( 'success' );
	}
}
die( 'Error' );
?>